(() => {
if (!navigator.userAgent.includes("CrOS")) {
  showStatus("N·u·m·L·o·c·k", "Traditional NumLock behaviour<br>Only useful on ChromeOS");
  return;
}
console.log("NumLock for ChromeOS started.");
if (window.NUMLOCK_BOOKMARKLET) return;
window.NUMLOCK_BOOKMARKLET = true;

let isEnabled = true;
const keyMap = {
  "Numpad7": "Home", "Numpad1": "End", "Numpad8": "ArrowUp", "Numpad2": "ArrowDown",
  "Numpad4": "ArrowLeft", "Numpad6": "ArrowRight", "Numpad9": "PageUp",
  "Numpad3": "PageDown", "Numpad0": "Insert", "NumpadDecimal": "Delete"
};

function showStatus(title, message, timeout = 2000) {
  const existing = document.getElementById("numlock-status");
  if (existing) document.body.removeChild(existing);
  const div = document.createElement("div");
  div.id = "numlock-status";
  div.style = `
    position: fixed;
    top: 0;
    right: 0;
    padding: 12px 16px;
    background: rgba(0,0,0,0.8);
    color: #fd0;
    border-radius: 4px;
    font-family: monospace;
    font-size: 14px;
    z-index: 99999;
    animation: fadein .7s ease-in-out;
  `;
  div.innerHTML = `<strong>${title}</strong><br>${message}`;
  document.body.appendChild(div);
  setTimeout(() => {
    div.style.animation = "fadeout 0.7s";
    setTimeout(() => div.remove(), 650);
  }, timeout);

  const style = document.createElement("style");
  style.textContent = `
    @keyframes fadein {from {opacity:0;}}
    @keyframes fadeout {to {opacity:0;}}
  `;
  document.head.appendChild(style);
}

function handleDelete() {
  const el = document.activeElement;
  if (!el || !(el.tagName==="INPUT" || el.tagName==="TEXTAREA")) return;
  const start = el.selectionStart;
  const end = el.selectionEnd;
  el.value = el.value.substring(0, start) + el.value.substring(end);
  el.selectionStart = el.selectionEnd = start;
  el.dispatchEvent(new Event("input", { bubbles: true }));
}

function execCutCopyPaste(action) {
  const el = document.activeElement;
  if (!el || !(el.tagName==="INPUT" || el.tagName==="TEXTAREA")) return;
  if (action==="cut") {
    const text = el.value.substring(el.selectionStart, el.selectionEnd);
    if (text) {
      navigator.clipboard.writeText(text).catch(() => {});
      el.value = el.value.substring(0, el.selectionStart) + el.value.substring(el.selectionEnd);
      el.selectionEnd = el.selectionStart;
      el.dispatchEvent(new Event("input", { bubbles: true }));
    }
  } else if (action==="paste") {
    navigator.clipboard.readText().then(text => {
      if (text) {
        const start = el.selectionStart;
        el.value = el.value.substring(0, start) + text + el.value.substring(el.selectionEnd);
        el.selectionStart = el.selectionEnd = start + text.length;
        el.dispatchEvent(new Event("input", { bubbles: true }));
      }
    }).catch(() => {});
  }
}

function handleKey(key, shift) {
  if (key==="Delete") return shift ? execCutCopyPaste("cut") : handleDelete();
  if (key==="Insert" && shift) return execCutCopyPaste("paste");
  const el = document.activeElement;  
  if (!el || !(el.tagName==="INPUT" || el.tagName==="TEXTAREA")) {
    if (key==="Home") window.scrollTo(0, 0);
    else if (key==="End") window.scrollTo(0, document.body.scrollHeight);
    else if (key==="PageUp") window.scrollBy(0, -window.innerHeight * 0.9);
    else if (key==="PageDown") window.scrollBy(0, window.innerHeight * 0.9);
    return;
  }
  const len = el.value.length;
  let start = el.selectionStart, end = el.selectionEnd;
  switch (key) {
    case "ArrowLeft":
      if (shift) {
        if (start===end) end = start;
        el.selectionStart = Math.max(0, start - 1);
      } else {
        el.selectionStart = el.selectionEnd = Math.max(0, start - 1);
      }
      break;
    case "ArrowRight":
      if (shift) {
        if (start===end) end = start;
        el.selectionEnd = Math.min(len, end + 1);
      } else {
        el.selectionStart = el.selectionEnd = Math.min(len, start + 1);
      }
      break;
    case "Home":
      if (shift) el.selectionStart = 0;
      else el.selectionStart = el.selectionEnd = 0;
      break;
    case "End":
      if (shift) el.selectionEnd = len;
      else el.selectionStart = el.selectionEnd = len;
      break;
  }
  el.dispatchEvent(new Event("input", { bubbles: true }));
}

function onKey(e) {
		if (e.shiftKey && e.code==="F10"){				
			console.log("Kontext!");
			e.target.dispatchEvent(new MouseEvent("contextmenu",{bubbles:true,cancelable:true,view:window,button:2}));
			return;				
		}	
  if (e.code==="NumLock") {
    e.preventDefault();
    isEnabled = !isEnabled;
    showStatus("N·u·m·L·o·c·k", `Arrow Keys ${isEnabled ? "ACTIVATED" : "DEACTIVATED"}`);
    return;
  }
  if (!isEnabled) return;
  if (keyMap[e.code]) {
    e.preventDefault();
    handleKey(keyMap[e.code], e.shiftKey);
  }
}

document.addEventListener("keydown", onKey);
showStatus("N·u·m·L·o·c·k", "Arrow Keys ACTIVATED");

})();
