:: :::::::::::::::::::::::::::::::::::::::
::  _create-Thumbnails                  ::
::  Thumbnails erstellen mit IrfanView  ::
::  (c) 2005-2025 Thomas Bigler         ::
:: :::::::::::::::::::::::::::::::::::::::

@ECHO OFF
CHCP 1252 >NUL

ECHO.
ECHO  Kleinschreibung aller Dateinamen und (Leerzeichen = -) . . .
FORFILES /s /m *.* /C "cmd /e:on /v:on /c set \"Phile=@file\" & if @ISDIR==FALSE ren @file !Phile: =-!"
for /f "Tokens=*" %%f in ('dir /l/b/a-d') do (rename "%%f" "%%f")

SET IRFAN=%ProgramW6432%\IrfanView\i_view64.exe
IF NOT EXIST "%IRFAN%" SET IRFAN=%ProgramFiles(x86)%\IrfanView\i_view32.exe
IF NOT EXIST "%IRFAN%" ECHO IrfanView nicht gefunden. & PAUSE & EXIT

ECHO.
ECHO  Erstelle Thumbnails und Web-optimierte Bilder . . .
"%IRFAN%" "*.jpg" /silent /resize_long=400 /aspectratio /resample /jpgq=70 /convert="$N_t.jpg"
"%IRFAN%" "*.jfif" /silent /resize_long=400 /aspectratio /resample /jpgq=70 /convert="$N_t.jfif"
"%IRFAN%" "*.webp" /silent /resize_long=400 /aspectratio /resample /convert="$N_t.webp"
"%IRFAN%" "*.gif" /silent /resize_long=400 /aspectratio /resample /convert="$N_t.gif"

:: :::::::::::::::::::::::::::::::::::::::
::  Web-optimierte Bilder mit IrfanView ::
::  (c) 2005-2025 Thomas Bigler         ::
:: :::::::::::::::::::::::::::::::::::::::

"%IRFAN%" "*.jpg" /silent /resize_long=1600 /aspectratio /resample /jpgq=70 /convert="$N_w.jpg"
"%IRFAN%" "*.jfif" /silent /resize_long=1600 /aspectratio /resample /jpgq=70 /convert="$N_w.jfif"
"%IRFAN%" "*.webp" /silent /resize_long=1600 /aspectratio /resample /convert="$N_w.webp"
"%IRFAN%" "*.gif" /silent /resize_long=1600 /aspectratio /resample /convert="$N_w.gif"

del /Q "*_t_t.*" >nul 2>&1
del /Q "*_w_w.*" >nul 2>&1
del /Q "*_w_t.*" >nul 2>&1
del /Q "*_t_w.*" >nul 2>&1
ECHO.
ECHO  Done.
ping -n 3 localhost >NUL
CLS
