﻿// JS-Funktionen für IMG-Bilder-Zoom (class="bild zoom")
// CSS Responsive Menu Generator (c) Thomas Bigler 2005-2025

"use strict";

var y=0,zoomShown="";
function zeig(el){
  zoomShown=el;
  y=window.scrollY;window.scrollTo(0,0);
  var zoom =document.getElementById("zoom");
  var innen=document.getElementById("zoom_innen");
  zoom.style.display="block";
  zoom.style.zIndex="9999";
  innen.style.backgroundImage="url("+el.src.replace(/\_t.(?=[^_t.]*$)/,".")+")";   // großes Bild
  innen.setAttribute("title",el.nextElementSibling.textContent);
  document.body.style.overflow="hidden";

  // Grau wegen SVG-Transparenz!
  // innen.style.backgroundColor="";
  // if (el.src.indexOf(".svg")>-1) innen.style.backgroundColor="#888";
}

function zeig_zu(){
  window.scrollTo(0,y);
  document.getElementById("zoom").style.display="none";
  document.body.style.overflow="";
}

function zoomLimitEnde(){
  document.getElementById("zoom_innen").style.backgroundColor="";
}

function zoomLimit(){
  document.getElementById("zoom_innen").style.backgroundColor="black";
  setTimeout(zoomLimitEnde,111);
}

function nextImg(e){
  const fund=document.getElementsByClassName("bild zoom");
  for (let i=0; i<fund.length; i++){
    if (fund[i]==e) {if (i+2>fund.length) zoomLimit(); return fund[i+1];break;}
  }
  return e;
}

function prevImg(e){
  const fund=document.getElementsByClassName("bild zoom");
  for (let i=0; i<fund.length; i++){
    if (fund[i]==e) {if (i<1) zoomLimit(); return fund[i-1];break;}
  }
  return e;
}

function prevImgUp(e){
  const fund=document.getElementsByClassName("bild zoom");
  for (let i=0; i<fund.length; i++){
    if (fund[i]==e) {i-=10; if (i>-1) return fund[i];break;}
  }
  return fund[0];
}

function nextImgDn(e){
  const fund=document.getElementsByClassName("bild zoom");
  for (let i=0; i<fund.length; i++){
    if (fund[i]==e) {i+=10; if (i<fund.length-1) return fund[i];break;}
  }
  return fund[fund.length-1];
}

function firstImg(){
  const fund=document.getElementsByClassName("bild zoom");
  return fund[0];
}

function lastImg(){
  const fund=document.getElementsByClassName("bild zoom");
  return fund[fund.length-1];
}

function zoomLinks(){
  const n=prevImg(zoomShown);
  if (n) {zeig_zu();n.focus();zeig(n);}
}

function zoomRechts(){
  const n=nextImg(zoomShown);
  if (n) {zeig_zu();n.focus();zeig(n);}
}

document.addEventListener("DOMContentLoaded", function(event) {
  const fund=document.getElementsByClassName("bild zoom");
  for (let i=0; i<fund.length; i++){
    fund[i].setAttribute("tabindex","0");                 // anwählbar mit TAB-Taste
    fund[i].setAttribute("loading","lazy");               // erst laden sobald sichtbar
    fund[i].addEventListener("error",
      function(){
        this.onerror=null;
        console.clear();
        this.src=this.src.replace(/\_t.(?=[^_t.]*$)/,".");   // kein _t.* Thumbnail da -> Bild umbenennen!
      });
    if (fund[i].src.indexOf(".svg")<0)
      fund[i].src=fund[i].src.replace(/\.(?=[^.]*$)/,"_t.")  // _t.* Thumbnail-Endung versuchen, nicht bei .svg
    fund[i].addEventListener("click", function(){zeig(this)});

    fund[i].addEventListener("keydown",function(e){
      if (e.key=="ArrowRight"){
        e.stopPropagation();
        var wasOpen=(document.getElementById("zoom").style.display=="block");
        var n=nextImg(this);
        if (n) {zeig_zu();n.focus();if (wasOpen) zeig(n);}
      } else if (e.key=="ArrowLeft"){
        e.stopPropagation();
        var wasOpen=(document.getElementById("zoom").style.display=="block");
        var n=prevImg(this);
        if (n) {zeig_zu();n.focus();if (wasOpen) zeig(n);}
      } else if (!e.ctrlKey && !e.shiftKey && (e.key=="Home" || e.key=="Numpad7")) {
        e.stopPropagation();
        var wasOpen=(document.getElementById("zoom").style.display=="block");
        var n=firstImg();
        if (n) {zeig_zu();n.focus();if (wasOpen) zeig(n);}
      } else if (!e.ctrlKey && !e.shiftKey && (e.key=="PageUp" || e.key=="Numpad9")) {
        e.stopPropagation();e.preventDefault();
        var wasOpen=(document.getElementById("zoom").style.display=="block");
        var n=prevImgUp(this);
        if (n) {zeig_zu();n.focus();if (wasOpen) zeig(n);}
      } else if (!e.ctrlKey && !e.shiftKey && (e.key=="PageDown" || e.key=="Numpad3")) {
        e.stopPropagation();e.preventDefault();
        var wasOpen=(document.getElementById("zoom").style.display=="block");
        var n=nextImgDn(this);
        if (n) {zeig_zu();n.focus();if (wasOpen) zeig(n);}
      } else if (!e.ctrlKey && !e.shiftKey && (e.key=="End" || e.key=="Numpad1")) {
        e.stopPropagation();e.preventDefault();
        var wasOpen=(document.getElementById("zoom").style.display=="block");
        var n=lastImg();
        if (n) {zeig_zu();n.focus();if (wasOpen) zeig(n);}
      } else if (e.key=="Enter") {zeig(this)
      } else if (e.key=="Escape" || e.key=="Tab") zeig_zu();
     }
    );
    fund[i].title+="\n\nKlick \u21E8 Zoom\u2026";
  }

  if (fund[0]) {            // Bilder vorhanden? -> Zoom-DIV erstellen
    createZoomDiv();
    fund[0].focus();
    if (fund.length<2) {    // Nur 1 Zoom-Bild?
      document.getElementById("zLinks").style.display="none";
      document.getElementById("zRechts").style.display="none";
    }
  }
});

function createZoomDiv(){
let div,a,t,innen;
  div=document.createElement("div");
  div.setAttribute("id","zoom");
  a=document.createElement("a");a.setAttribute("class","zu");
   a.setAttribute("onclick","zeig_zu()");
   a.setAttribute("title","Close / Schließen\n\n[Esc]");
   t=document.createTextNode("\u2573");a.appendChild(t);
   div.appendChild(a);
  a=document.createElement("a");a.setAttribute("class","zLinks");a.setAttribute("id","zLinks");
   a.setAttribute("onclick","zoomLinks()");
   a.setAttribute("title","\u2190");
   t=document.createTextNode("\u3008");a.appendChild(t);
   div.appendChild(a);
  a=document.createElement("a");a.setAttribute("class","zRechts");a.setAttribute("id","zRechts");
   a.setAttribute("onclick","zoomRechts()");
   a.setAttribute("title","\u2192");
   t=document.createTextNode("\u3009");a.appendChild(t);
   div.appendChild(a);
  innen=document.createElement("div");
   innen.setAttribute("id","zoom_innen");
   innen.setAttribute("onclick","zeig_zu()");
   div.appendChild(innen);
  document.body.insertBefore(div,document.body.firstChild);
}

// Funktionen für MAP/AREA
function zeigLegende(el){
  el.focus();
  document.getElementById("legende").textContent=el.title;
}
function zeigKarte(el){el.parentNode.parentNode.parentNode.focus();}

// HTML5-Ersatz für js-alert()
function Alert(s){
let d=document.createElement("dialog"),v=document.createElement("div"),ok=document.createElement("button"),style=document.createElement("style");
  style.innerHTML="#alertDlg{max-width:80vw;width:300px;padding:1em;user-select:none;border-radius:8px;font-size:1.1rem;}#alertDlg::backdrop{background-color:rgba(0,0,0,.5);}#alertDlg button{margin: 1rem 1rem 0 0;background:#1a73e8;color:white;border-radius:.2rem;min-width:3rem;padding:.3rem;}#alertDlg button:hover{background:#1a73e8;color:#0f0;}#confirmDlg h3{margin-top:0;}";
  d.id="alertDlg";d.appendChild(style);d.setAttribute("onclick","event.target==this && this.remove();");v.innerHTML=s.replace(/[\n\r]/g,"<br>");d.appendChild(v);
  ok.innerHTML="OK";ok.setAttribute("onclick","this.parentElement.remove();");d.appendChild(ok);
  document.body.appendChild(d);d.showModal();
}

// Zahl im CH-Format ausgeben (12345.6789 → 12'345.6789)
function zahlCH(x){return x.toLocaleString("de-CH",{maximumFractionDigits:10});}

