@ECHO OFF
:: :::::::::::::::::::::::::::::::::::::::::
:: _Setup_NNN.cmd, (c) Thomas Bigler 2025 ::
:: :::::::::::::::::::::::::::::::::::::::::

:: Check Privileges
NET FILE 1>NUL 2>NUL
IF "%errorlevel%"=="0" (goto gotPrivileges) else (goto getPrivileges)

:getPrivileges
if "%1"=="ELEV" (shift & goto gotPrivileges)
SETLOCAL DisableDelayedExpansion
SET P=ELEV
IF /i "%1"=="/S" SET P=ELEVS
powershell.exe -NoProfile -ExecutionPolicy Bypass -Command "Start-Process '%~dpnx0' %P% -Verb runas"
goto :EOF

:gotPrivileges

:: :::::::::::::::::::::::::::::::::::::::
SETLOCAL
COLOR F0

MODE CON: COLS=80 LINES=12
SET ECHOLINE=ECHO  

:: x86-Setups on x64
SET PF=%ProgramFiles%
SET PF64=%PF%
IF DEFINED ProgramFiles(x86) SET PF=%ProgramFiles(x86)%
IF DEFINED ProgramFiles(x86) SET PF64=%ProgramW6432%
IF DEFINED ProgramFiles(x86) SET REGNODE=/reg:64
SET REGNODE32=/reg:32

:: ============================================
SET NAME=zFonts - Font Viewer
SET COMPANY=Bigler
SET PRODUCT=%NAME%
SET AppFolder=zFonts
SET COMM1=Preview of all installed fonts
SET COMM2=Freeware, (C) 2002-2025 Thomas Bigler
:: ============================================

TITLE %NAME% (Installation)
ECHO.
ECHO   %NAME% (Installation)
%ECHOLINE%
IF NOT "%COMM1%"=="" ECHO   %COMM1%
IF NOT "%COMM2%"=="" ECHO   %COMM2%
ECHO.

IF /i "%1"=="/S" GOTO SILENT
IF /i "%1"=="ELEVS" GOTO SILENT
ECHO   Press any key to start . . .
PAUSE >NUL
:SILENT
PUSHD "%~dp0"

COLOR FC
CLS
ECHO.
ECHO   %NAME% (Installation)
%ECHOLINE%
ECHO.
ECHO   %NAME% - Installation running . . .
ECHO.

:: --- GENERIC CMD INSTALLER ---------
MD "%PF%\%COMPANY%\%AppFolder%"
XCOPY "_UnInstall_zFonts.cmd" "%PF%\%COMPANY%\%AppFolder%" /E /F /R /Y
XCOPY "*.exe" "%PF%\%COMPANY%\%AppFolder%" /E /F /R /Y
:: remove ev. legacy version


:: Add Publisher for Uninstall-List
SET UIENTRY=HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\%NAME%
REG ADD "%UIENTRY%" /v "Publisher" /t REG_SZ /d "Thomas Bigler" /f %REGNODE% 2>NUL
REG ADD "%UIENTRY%" /v "DisplayName" /t REG_SZ /d "%NAME%" /f %REGNODE% 2>NUL
REG ADD "%UIENTRY%" /v "DisplayIcon" /t REG_SZ /d "%PF%\%COMPANY%\%AppFolder%\zFonts.exe" /f %REGNODE% 2>NUL
REG ADD "%UIENTRY%" /v "UninstallString" /t REG_SZ /d "%PF%\%COMPANY%\%AppFolder%\_UnInstall_zFonts" /f %REGNODE% 2>NUL
REG ADD "%UIENTRY%" /v "QuietUninstallString" /t REG_SZ /d "%PF%\%COMPANY%\%AppFolder%\_UnInstall_zFonts.cmd /S" /f %REGNODE% 2>NUL
REG ADD "%UIENTRY%" /v "DisplayVersion" /t REG_SZ /d "1.6.0.0" /f %REGNODE% 2>NUL
REG ADD "%UIENTRY%" /v "EstimatedSize" /t REG_DWORD /d 75 /f %REGNODE% 2>NUL
REG ADD "%UIENTRY%" /v "NoModify" /t REG_DWORD /d 1 /f %REGNODE% 2>NUL
REG ADD "%UIENTRY%" /v "NoRepair" /t REG_DWORD /d 1 /f %REGNODE% 2>NUL
REG ADD "%UIENTRY%" /v "URLInfoAbout" /t REG_SZ /d "http://home.datacomm.ch/t.bigler/" /f %REGNODE% 2>NUL

:: Add App Paths, so zFonts can be found from CLI
SET UIENTRY=HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\zFonts.exe
REG ADD "%UIENTRY%" /ve /t REG_SZ /d "%PF%\%COMPANY%\%AppFolder%\zFonts.exe" /f %REGNODE% 2>NUL


:: --- START CreateLinks --------------------------------------------------
:: AE=   OE=   UE=   ae=   oe=   ue=   sz=   (depends on CreateLink.vbs)
CHCP 1252

:: Setting paths for all users
SET StartMenuPrograms=%ALLUSERSPROFILE%\Microsoft\Windows\Start Menu\Programs
SET StartMenu=%ALLUSERSPROFILE%\Microsoft\Windows\Start Menu

:: Link on Start Menu (All Users)
:: remove old
DEL /Q/F "%StartMenu%\zFonts*.lnk"

:: CreateLink.exe here?
createlink.exe >NUL
if errorlevel 1 goto CLvbs

:CLexe
:: Syntax: CreateLink.exe Link Target [Argument(s)] [WorkingDirectory] [Description] [IconPath] [IconNumber] [WndParams]
call :CreateLink "%StartMenuPrograms%\zFonts - Schriftarten betrachten.lnk" "%PF%\%COMPANY%\%AppFolder%\zFonts.exe" "" "" "Schriftarten betrachten"

goto CLdone

:CLvbs
:: Syntax: call :CreateLink Link Target [Argument(s)] [WorkingDirectory] [Description] [IconPath]
:: Adapt for english Link
call :CreateLink "%StartMenuPrograms%\zFonts - Schriftarten betrachten.lnk" "%PF%\%COMPANY%\%AppFolder%\zFonts.exe" "" "" "Schriftarten betrachten"
:: call :CreateLink "%StartMenuPrograms%\zFonts - Quick fonts preview.lnk" "%PF%\%COMPANY%\%AppFolder%\zFonts.exe" "" "" "See installed fonts"

:CLdone
CHCP 850

:: --- END CreateLinks ----------------------------------------------------


ECHO.
COLOR F0
IF /i "%1"=="/S" GOTO FERTIG
CLS
ECHO.
ECHO   %NAME% (Installation)
%ECHOLINE%
ECHO.
ECHO   %NAME% has been installed.
ECHO.
ECHO   This window will close automatically in 3 seconds . . .
ECHO.
ping -n 3 localhost >NUL
:FERTIG
POPD
ENDLOCAL

goto :EOF
:: --- Sub CreateLink ------cut-if-not-used-------------------------------
:CreateLink
SETLOCAL
powershell.exe -NoProfile -ExecutionPolicy Bypass "$s=(New-Object -COM WScript.Shell).CreateShortcut('%~1');$s.TargetPath='%~2';$s.Arguments='%~3';$s.WorkingDirectory='%~4';$s.Description='%~5';$s.IconLocation='%~6';$s.IconArrayIndex='%~7';$s.WindowStyle='%~8';$s.Save();" >NUL
ENDLOCAL
goto :EOF