@ECHO OFF
:: :::::::::::::::::::::::::::::::::::::::::::::
:: _UnInstall_XXX.cmd, (c) Thomas Bigler 2024 ::
:: :::::::::::::::::::::::::::::::::::::::::::::

:: Check Privileges
NET FILE 1>NUL 2>NUL
IF "%errorlevel%"=="0" (goto gotPrivileges) else (goto getPrivileges)

:getPrivileges
if "%1"=="ELEV" (shift & goto gotPrivileges)
SETLOCAL DisableDelayedExpansion
SET P=ELEV
IF /i "%1"=="/S" SET P=ELEVS
powershell.exe -NoProfile -ExecutionPolicy Bypass -Command "Start-Process '%~dpnx0' %P% -Verb runas"
goto :EOF

:gotPrivileges

:: :::::::::::::::::::::::::::::::::::::::::::
SETLOCAL
COLOR F0
MODE CON: COLS=80 LINES=25
SET ECHOLINE=ECHO  

:: x86-Setups on x64
SET PF=%ProgramFiles%
SET PF64=%PF%
IF DEFINED ProgramFiles(x86) SET PF=%ProgramFiles(x86)%
IF DEFINED ProgramFiles(x86) SET PF64=%ProgramW6432%

:: ==========================
SET NAME=zFonts - Font Viewer
SET COMPANY=Bigler
SET PRODUCT=%NAME%
SET AppFolder=zFonts
:: ==========================

TITLE %NAME% (Uninstall)
ECHO.
ECHO   %NAME% (Uninstall)
%ECHOLINE%
ECHO.

IF /i "%1"=="/S" GOTO SILENT
IF /i "%1"=="ELEVS" GOTO SILENT
ECHO   Press any key to start . . .
PAUSE >NUL
:SILENT

COLOR FC
CLS
ECHO.
ECHO   %NAME% (Uninstall)
%ECHOLINE%
ECHO.
ECHO   %NAME% - (Uninstallation)
ECHO   is running . . .
ECHO.

:: Remove Entry for Uninstall-List
REG DELETE "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\%NAME%" /f >NUL

:: --- UNINSTALLER cmd ------------------------------------
:: Brute Force, adapt!
:: ECHO "%PF%\%COMPANY%\%AppFolder%"
RD /S /Q "%PF%\%COMPANY%\%AppFolder%"


:: --- Remove Startmenu Links -----------------------------
:: W7/Vista
SET isXP=0
SET StartMenuPrograms=%ALLUSERSPROFILE%\Microsoft\Windows\Start Menu\Programs
SET StartMenu=%ALLUSERSPROFILE%\Microsoft\Windows\Start Menu
IF EXIST "%StartMenu%" goto ClReady

:: XP/2k
SET isXP=1
SET StartMenuPrograms=%ALLUSERSPROFILE%\STARTM~1\Programme
SET StartMenu=%ALLUSERSPROFILE%\STARTM~1

:ClReady
DEL /Q/F "%StartMenuPrograms%\zFonts*.lnk"

:: App Paths -> App cannot be found anymore in CLI
REG DELETE "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\zFonts.exe" /f >NUL
:: --- Clean Up END ---------------------------------------

ECHO.
COLOR F0
IF /i "%1"=="/S" GOTO FERTIG
CLS
ECHO.
ECHO   %NAME% (Uninstall)
%ECHOLINE%
ECHO.
ECHO   %NAME% has been uninstalled.
ECHO.
ECHO   This window will close automatically in 3 seconds . . .
ECHO.
ping -n 3 localhost >NUL
:FERTIG
ENDLOCAL
